/*******************************************************************************

   Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

 *******************************************************************************

   $Id:: SercosIII_SlAP_Public.h 69737 2017-06-26 12:47:52Z DenisJ             $

   Description:
    The header contains the public definition of task.
    It has to be included by another task to get access of task specfic definition.

    Includes following functions:

   Changes:

     Date          Description
     ---------------------------------------------------------------------------
     2014-02-23    header created
*******************************************************************************/

/**
 * @file SercosIII_SlAP_Public.h
 *  SercosIII_Sl AP - public definition of task
 *
 * The header contains the public definition of task.
 * It has to be included by another task to get access of task specfic definition.
 *
 * @note
 * The structures for the services must be packed on 1 byte of boundary.
 * The <code>#pragma</code> instructions are already planned for Microsoft compiler.
 * For gnu's compiler and Realview compiler the macros <code>__TLR_PACKED_PRE</code>
 * and <code>__TLR_PACKED_POST</code> have to be added with the structural definition
 * in addition.
 */
#ifndef __SIII_SL_AP_PUBLIC_H
#define __SIII_SL_AP_PUBLIC_H

/*************************************************************************************/
/** @name Queue Name
 *
 * Use the queue name to identify the process queue of task 'SercosIII_Sl AP'.
 * Example for internal identification:<br>
 * @code
 * TLR_RESULT eRslt;
 * TLR_HANDLE hQue;
 * TLR_UINT   uiInstance = 0;
 *
 * eRslt = TLR_QUE_IDENTIFY_INTERN(
 *                                 SIII_SL_AP_QUEUE_NAME,
 *                                 uiInstance,
 *                                 &hQue
 *                                );
 * @endcode
 * <br>
 * Example for external or normal identification:<br>
 * @code
 * TLR_RESULT      eRslt;
 * TLR_QUE_LINK_T  tQue;
 * TLR_UINT        uiInstance = 0;
 *
 * eRslt = TLR_QUE_IDENTIFY(SIII_SL_AP_QUEUE_NAME, uiInstance, &tQue);
 * @endcode
 * <br>
 * @{
 */
/** queue name */
#define SIII_SL_AP_QUEUE_NAME        "QUE_S3_SL_AP"

/** @} */

/* host send warmstart to AP-Task to configure device */
#define SIII_SL_AP_CMD_SET_CONFIGURATION_REQ            0x00003628
#define SIII_SL_AP_CMD_SET_CONFIGURATION_CNF            0x00003629

/*************************************************************************************/
/* packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__SIII_SL_AP_PACKET)
#endif


typedef __TLR_PACKED_PRE struct SIII_SL_DPM_EXT_STATUS_Ttag
{
  TLR_UINT8               bCommunicationPhase;
  TLR_UINT8               abCommunicationPhaseAscii[3];   /* in writing: NRT, CP0, CP1, CP2, CP3, CP4 */
} __TLR_PACKED_POST SIII_SL_DPM_EXT_STATUS_T;

#define SIII_SL_DPM_EXT_STATUS_CURRENT_COMMUNICATION_PHASE_NRT    0x7F
#define SIII_SL_DPM_EXT_STATUS_CURRENT_COMMUNICATION_PHASE_CP0    0x00
#define SIII_SL_DPM_EXT_STATUS_CURRENT_COMMUNICATION_PHASE_CP1    0x01
#define SIII_SL_DPM_EXT_STATUS_CURRENT_COMMUNICATION_PHASE_CP2    0x02
#define SIII_SL_DPM_EXT_STATUS_CURRENT_COMMUNICATION_PHASE_CP3    0x03
#define SIII_SL_DPM_EXT_STATUS_CURRENT_COMMUNICATION_PHASE_CP4    0x04

/******************************************************************************
 * Packet:  SIII_SL_AP_CMD_SET_CONFIGURATION_REQ/SIII_SL_AP_CMD_SET_CONFIGURATION_CNF */

typedef __TLR_PACKED_PRE struct SIII_SL_AP_SET_CONFIGURATION_TCP_DATA_Ttag
{
  /** Parameters for TCP/IP-Stack */
  TLR_UINT32      ulTcpFlag;
  /** IP Address (IP is little-endian formatted) */
  TLR_UINT32      ulIpAddr;
  /** Netmask (little endian formatted) */
  TLR_UINT32      ulNetMask;
  /** Gateway address (little endian formatted) */
  TLR_UINT32      ulGateway;
} __TLR_PACKED_POST SIII_SL_AP_SET_CONFIGURATION_TCP_DATA_T;

/* supported TCP/IP flags */
#define SIII_SL_AP_TCPIP_CFG_FLAG_IP_ADDR               0x0001
#define SIII_SL_AP_TCPIP_CFG_FLAG_NET_MASK              0x0002
#define SIII_SL_AP_TCPIP_CFG_FLAG_GATEWAY               0x0004
#define SIII_SL_AP_TCPIP_CFG_FLAG_BOOTP                 0x0008
#define SIII_SL_AP_TCPIP_CFG_FLAG_DHCP                  0x0010

/* This  setup must be equal to the Sercos Version tested by the conformizer */
#define SIII_SL_AP_SPECIFICATION_COMPATIBILITY_MODE_V_1_1_2    0x0 /* Stack is running compatible to conformizer V1.1.2 */
#define SIII_SL_AP_SPECIFICATION_COMPATIBILITY_MODE_V_1_3_1    0x1 /* Stack is running compatible to conformizer V1.3.1 */

/* Device configuration data */
typedef __TLR_PACKED_PRE struct SIII_SL_AP_SET_CONFIGURATION_DEVICE_CFG_DATA_Ttag
{
  TLR_UINT8       bProcDataMode;                /* configures mode of handling process data */
  TLR_UINT8       bProcDataOutputUpdateMode;    /* not implemented yet */
  TLR_UINT8       bProcDataInputUpdateMode;     /* not implemented yet */
  TLR_UINT8       bNumOfSlaves;
  TLR_UINT8       bSCP_Sync_Version;
  TLR_UINT8       bSCP_SIP_Version;             /* SIP Version (just 1 supported) */
  TLR_UINT8       bSCP_NRT_Version;
  TLR_UINT8       bSercosVersion;               /* The Sercos version to which the stack shall be compatible. Needed to pass the conformizer of the configured version. */
  TLR_UINT16      ausReserved[3];
  TLR_UINT16      usVendorCode;
  TLR_UINT8       abDeviceId[256];              /* NUL-terminated string */
  TLR_UINT32      ulInputDataErrorThreshold;    /* not implemented yet */
  TLR_UINT32      ulOutputDataErrorThreshold;   /* not implemented yet */
  TLR_UINT32      ulSyncErrorThreshold;         /* not implemented yet */
} __TLR_PACKED_POST SIII_SL_AP_SET_CONFIGURATION_DEVICE_CFG_DATA_T;

#define SIII_SL_AP_SET_CONFIGURATION_DEVICE_PROCDATA_MODE_BUS_SYNC              0x0
#define SIII_SL_AP_SET_CONFIGURATION_DEVICE_PROCDATA_MODE_TRIPLE_BUFFER         0x1
#define SIII_SL_AP_SET_CONFIGURATION_DEVICE_PROCDATA_MODE_SEPARATE_AT_CALLBACK  0x2

#define SIII_SL_AP_SET_CONFIGURATION_MAX_CONNS_PER_SLAVE                  4

typedef __TLR_PACKED_PRE struct SIII_SL_AP_SET_CONFIGURATION_CONN_CFG_DATA_Ttag
{
  TLR_UINT16      usProcImgConnCtrlOffset;
  TLR_UINT16      usProcImgRtDataOffset;
  TLR_UINT16      usProcImgMaxRtDataLength;
} __TLR_PACKED_POST SIII_SL_AP_SET_CONFIGURATION_CONN_CFG_DATA_T;

/* Slave configuration data */
typedef __TLR_PACKED_PRE struct SIII_SL_AP_SET_CONFIGURATION_SLAVE_CFG_DATA_Ttag
{
  TLR_UINT16                                    usSercosAddress;
  TLR_UINT16                                    usSlaveFlags;
  TLR_UINT16                                    usSCP_CfgType;
  TLR_UINT32                                    ulFSP_Type;                   /* value of S-0-1302.0.1 */
  TLR_UINT16                                    usSCP_FixCfg_OutputDataSize;  /* output data in bytes / network view i.e. master->slave (FixCFG only) (excluding connection control and I/O Control) */
  TLR_UINT16                                    usSCP_FixCfg_InputDataSize;   /* input data in bytes / network view i.e. slave->master (FixCFG only) (excluding connection control and I/O Status) */
  TLR_UINT16                                    ausUserSCP_Types[20];         /* 0x0 means end of list / at max 20 valid entries */
  SIII_SL_AP_SET_CONFIGURATION_CONN_CFG_DATA_T  atConnDataOffsets[SIII_SL_AP_SET_CONFIGURATION_MAX_CONNS_PER_SLAVE];
} __TLR_PACKED_POST SIII_SL_AP_SET_CONFIGURATION_SLAVE_CFG_DATA_T;

/* usSlaveFlags */
#define SIII_SL_AP_SET_CONFIGURATION_SLAVE_FLAGS_ADDRESS_IS_NOT_CHANGEABLE  0x0001
#define SIII_SL_AP_SET_CONFIGURATION_SLAVE_FLAGS_DELETE_NON_STACK_OBJECTS   0x0002
#define SIII_SL_AP_SET_CONFIGURATION_SLAVE_FLAGS_SETUP_DEFAULT_OD           0x0004  /* implies SIII_SL_AP_SET_CONFIGURATION_SLAVE_FLAGS_DELETE_NON_STACK_OBJECTS */
#define SIII_SL_AP_SET_CONFIGURATION_SLAVE_FLAGS_HANDLE_CONNCTRL            0x0008  /* handle ConnCtrl internally */
#define SIII_SL_AP_SET_CONFIGURATION_SLAVE_FLAGS_HANDLE_IOCTRL_IOSTATUS     0x0010  /* handle IOControl / IOStatus internally: only SCP_FixCfg with FSP_IO requires SIII_SL_AP_SET_CONFIGURATION_SLAVE_FLAGS_HANDLE_CONNCTRL to be set */


/* usSCP_CfgType */
#define SIII_SL_AP_SET_CONFIGURATION_SCP_TYPE_FIXCFG                        0x0101 /* use the FIXCFG version of the stack */
#define SIII_SL_AP_SET_CONFIGURATION_SCP_TYPE_FIXCFG_V1_1_1                 0x0101 /* Depreciated use SIII_SL_AP_SET_CONFIGURATION_SCP_TYPE_FIXCFG instead */
#define SIII_SL_AP_SET_CONFIGURATION_SCP_TYPE_VARCFG_V1_1_1                 0x0201
#define SIII_SL_AP_SET_CONFIGURATION_SCP_TYPE_VARCFG_V1_1_3                 0x0202

/* ausUserSCP_Types */
#define SIII_SL_AP_SET_CONFIGURATION_SCP_TYPE_WD_V1_1_1                     0x0401
#define SIII_SL_AP_SET_CONFIGURATION_SCP_TYPE_DIAG_V1_1_1                   0x0501
#define SIII_SL_AP_SET_CONFIGURATION_SCP_TYPE_RTB_V1_1_1                    0x0601
#define SIII_SL_AP_SET_CONFIGURATION_SCP_TYPE_MUX_V1_1_1                    0x0901
#define SIII_SL_AP_SET_CONFIGURATION_SCP_TYPE_SIG_V1_1_1                    0x0B01


/* ulFSP_Type */
#define SIII_SL_AP_SET_CONFIGURATION_FSP_TYPE_IO_V1                         0x00010001
#define SIII_SL_AP_SET_CONFIGURATION_FSP_TYPE_DRIVE_V1                      0x00020001
#define SIII_SL_AP_SET_CONFIGURATION_FSP_TYPE_ENCODER_V1                    0x00030001

typedef __TLR_PACKED_PRE struct SIII_SL_AP_SET_CONFIGURATION_SCP_SYNC_DATA_Ttag
{
  /** Sync Flags */
  TLR_UINT32                      ulSyncFlags;
  /** ConClk Length in ns */
  TLR_UINT32                      ulConClkLength;
  TLR_UINT32                      ulTDivClk;
  TLR_UINT32                      ulDTDivClk;     /* since V3.1.X: not used any more */
  TLR_UINT32                      ulDivClkLength; /* since V3.1.X: not used any more (default 1us)*/
  TLR_UINT32                      ulNDivClk;
  TLR_UINT32                      ulTInt2; /* not used */
  TLR_UINT32                      ulTInt3; /* not used */
} __TLR_PACKED_POST SIII_SL_AP_SET_CONFIGURATION_SCP_SYNC_DATA_T;

/* Sync configuration flags */
#define MSK_SIII_SL_AP_SYNC_FLAGS_CON_CLK_OUTPUT_ENABLE                     0x00000001
#define MSK_SIII_SL_AP_SYNC_FLAGS_CON_CLK_OUTPUT_HIGH_ACTIVE                0x00000002
#define MSK_SIII_SL_AP_SYNC_FLAGS_DIV_CLK_OUTPUT_ENABLE                     0x00000004
#define MSK_SIII_SL_AP_SYNC_FLAGS_DIV_CLK_OUTPUT_HIGH_ACTIVE                0x00000008
#define MSK_SIII_SL_AP_SYNC_FLAGS_DIV_CLK_MODE                              0x00000010
#define SRT_SIII_SL_AP_SYNC_FLAGS_DIV_CLK_MODE                              4
#define VAL_SIII_SL_AP_SYNC_FLAGS_DIV_CLK_MODE_0                            0x00000000
#define VAL_SIII_SL_AP_SYNC_FLAGS_DIV_CLK_MODE_1                            0x00000010


#define SIII_SL_AP_SET_CONFIGURATION_MAX_SLAVES                             8

/** Set Configuration request data
 *
 * Packet is similar to Warmstart, but behaviour after receive differs!
 * Host (via DPM) to the AP-Task on the device
 */
typedef __TLR_PACKED_PRE struct SIII_SL_AP_SET_CONFIGURATION_REQ_DATA_Ttag  /* Warmstart request data */
{
  /** system start behaviour */
  TLR_UINT32                                        ulSystemStart;
  /** watchdog time in ms */
  TLR_UINT32                                        ulWdgTime;
  /** Input/Output Status */
  TLR_UINT32                                        ulIOStatus;
  /** TCP/IP configuration data */
  SIII_SL_AP_SET_CONFIGURATION_TCP_DATA_T           tTcpCfg;
  /** Device configuration */
  SIII_SL_AP_SET_CONFIGURATION_DEVICE_CFG_DATA_T    tDeviceCfg;
  /** SCP_Sync configuration */
  SIII_SL_AP_SET_CONFIGURATION_SCP_SYNC_DATA_T      tSyncCfg;
  /** Slave configuration */
  SIII_SL_AP_SET_CONFIGURATION_SLAVE_CFG_DATA_T     atSlaveCfg[SIII_SL_AP_SET_CONFIGURATION_MAX_SLAVES];
} __TLR_PACKED_POST SIII_SL_AP_SET_CONFIGURATION_REQ_DATA_T;


/* system start flags */
#define MSK_SIII_SL_AP_SET_CONFIGURATION_APP_CONTROLLED       0x00000001

/** Set Configuration request
 *
 * The structure defines the request packet of the service.
 */
typedef __TLR_PACKED_PRE struct SIII_SL_AP_SET_CONFIGURATION_REQ_Ttag   /* Set Configuration request */
{
  /** packet header */
  TLR_PACKET_HEADER_T                       tHead;
  /** packet data */
  SIII_SL_AP_SET_CONFIGURATION_REQ_DATA_T   tData;
} __TLR_PACKED_POST SIII_SL_AP_SET_CONFIGURATION_REQ_T;


/** Set Configuration confirmation
 *
 * The structure defines the request packet of the service.
 */
typedef __TLR_PACKED_PRE struct SIII_SL_AP_SET_CONFIGURATION_CNF_Ttag   /* Set Configuration confirmation */
{
  /** packet header */
  TLR_PACKET_HEADER_T                   tHead;
  /* the confirmation packet has not data part */
} __TLR_PACKED_POST SIII_SL_AP_SET_CONFIGURATION_CNF_T;


/******************************************************************************/

typedef __TLR_PACKED_PRE struct SIII_SL_EXTENDED_STATUS_BLOCK_Ttag
{
  TLR_UINT8   bCurrentCP;
  TLR_UINT8   abCurrentCP_Str[4];   /* NRT\0, CP0\0, CP1\0, CP2\0, CP3\0, CP4\0 */
} __TLR_PACKED_POST SIII_SL_EXTENDED_STATUS_BLOCK_T;

#define VAL_SIII_SL_AP_CURRENT_PHASE_CP0          0x00
#define VAL_SIII_SL_AP_CURRENT_PHASE_CP1          0x01
#define VAL_SIII_SL_AP_CURRENT_PHASE_CP2          0x02
#define VAL_SIII_SL_AP_CURRENT_PHASE_CP3          0x03
#define VAL_SIII_SL_AP_CURRENT_PHASE_CP4          0x04
#define VAL_SIII_SL_AP_CURRENT_PHASE_NRT          0x7F


/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__SIII_SL_AP_PACKET)
#endif


/*************************************************************************************/
#endif /* #ifndef __SIII_SL_AP_PUBLIC_H */
